#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# SendFile2Newton
#---------------------------------------------------------------------

# $Log: SendFile2Newton.pl,v $
# Revision 1.10  1998/03/24 21:19:22  kalli
# Erweiterung um Soupname
#
# Revision 1.9  1998/03/06 23:26:57  kalli
# Umstellung auf neue ser. Treiber
#
# Revision 1.8  1997/12/06 17:24:50  kalli
# Umstellung auf Sloup
#
# Revision 1.7  1997/09/28 10:08:00  kalli
# Aenderung von Andrew :
# Select-Statement
#
# Revision 1.5  1997/03/27 19:48:10  kalli
# Andrew dazu
#
# Revision 1.4  1997/02/23 15:15:04  kalli
# Frank dazu
#
# Revision 1.3  1997/02/22 17:04:05  kalli
# GPL dazu
#
# Revision 1.2  1996/12/10 20:39:07  kalli
# Konvertierung deutscher Umlaute bei der Uebertragung
#
# Revision 1.1  1996/12/07 18:36:14  kalli
# Initial revision
#


sub SendFile2Newton {
    
    # open file
    open (SDFILE, "$SendFile") || printf "Can't open file : $!\n";

    # send soup header to Sloup
    if ($SendFileSoup ne "") {
        &send_line (COMNEWTON, "\n$SendFileSoup![]");
        &send_line (COMNEWTON, '{a:"string"}');
    }
    
    # read lines from file
    while (<SDFILE>) {

	# replace German Umlaute
	s//\232/g; s//\212/g; s//\237/g; s//\247/g; s//\205/g; s//\200/g; s//\206/g;
	# Print to STDOUT
	print "#";
	# send line to Sloup
	syswrite (COMNEWTON, $_, length($_)) || die "write systemcall failed";
    }

    # send soup end to Sloup
    if ($SendFileSoup ne "") {
        &send_line (COMNEWTON, "BYE!");
    }

    # close logfile
    close (SDFILE);

}

1;
