#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#-----------------------------------------------------------------------
# GreetUser
#-----------------------------------------------------------------------

# $Log: GreetUser.pl,v $
# Revision 1.1  1998/09/01 13:51:38  kalli
# Initial revision
#

sub GreetUser {

    my $notConnected = 1;
    my $MAXTIMEOUTS  = 5;
    my $numTimeouts  = 0;
    my $slpVersion;
    my $FirstName;
    my $LastName;

    # Checking if sloup is open
    print "Trying to connect to your Newton...\n";

    while ($notConnected) {

        if (open (COMNEWTON, "+>$tty")) {

            printf "Newton connection opened\n";

            # set new baudrate
   	    printf "Switch baudrate to $SloupBaudrate\n";
    	    &SetSloupBaudrate;

            # It seems that IRIX needs first a CR to initialize the serial connection
            if ($SystemType eq "IRIX") { printf (COMNEWTON "\n"); }

        }

        &send_line (COMNEWTON, "\nEVAL!\"OK\"");
        $_ = &receive_line (COMNEWTON);

        if ($_ ne "OK") {

            print "Make sure that sloup is working\n";
            print "Will try again in $timeout seconds\n";
            close (COMNEWTON);
            print "Connection closed\n";
            sleep ($timeout);
            $numTimeouts++;

            if ($numTimeouts > $MAXTIMEOUTS) {
                die "Tried for $numTimeouts times. Giving up\n";
            }
        } else {
            $notConnected=0;
            print "\n";
        }
    }
		
    # ask for Sloup version
    &send_line (COMNEWTON, "\nEVAL!GetRoot().|Sloup:TknollSys|._proto.versionString");
    $slpVersion = &receive_line (COMNEWTON);

    if ($slpVersion == "Timeout reached") {
        die "Please make sure your serial connection is working\n"
    }

    # ask for Newton user name
    &send_line (COMNEWTON, "\nEVAL!getUserConfig(\'name)");
    $_= &receive_line (COMNEWTON);
    ($FirstName,$LastName) = split(/ /,$_);

    print "Hi $FirstName, you are using Sloup $slpVersion\n";
}

1;
