#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# Get4XfmailAddressbook
#---------------------------------------------------------------------

# $Log: Get4XfmailAddressbook.pl,v $
# Revision 1.5  1998/07/05 17:16:55  kalli
# Alle Kommas raus bei Namen
#
# Revision 1.4  1998/03/07 17:49:35  kalli
# Umstellung auf Developer
#
# Revision 1.3  1997/12/17 09:41:18  kalli
# *** empty log message ***
#
# Revision 1.2  1997/11/17 19:30:06  kalli
# First rev.
#
# Revision 1.1  1997/11/17 18:52:07  kalli
# Initial revision
#

sub Get4XfmailAddressbook {

    # Get Newton addresses and write to Netscape addressbook file
    &Get4NetscapeAddressbook;

    # save old Xfmail Addressbook file
    if (-e "$XfmailAddressbookFile") {
	rename ("$XfmailAddressbookFile", "$XfmailAddressbookFile.bak");
    }
    
    # Open Netscape Navigator Addressbook file
    open (NSABOOKFILE, "$NetscapeNavigatorAddressbookFile")  || die "Can't open File : $!\n";

    # Open Xfmail Addressbook file
    open (XFBOOKFILE, ">> $XfmailAddressbookFile")  || die "Can't open File : $!\n";
    
    # print to stdout
    printf "Writing Xfmail addressbook file ...\n";
    
    while (<NSABOOKFILE>) {

	chop($_);
	
	if (/<\/DL>/) {
	    $folded = 0;
	}
	
	if(/<DT>/) {
	
	    if(/H3/) {
	    
		$folded = 1;
		s/<DT>//;
		s/<H3 FOLDED>//;
		s/<H3 NICKNAME=".*">//;
		s/<\/H3>//;
		s/ //g;
		s/,//g;
		printf XFBOOKFILE "@ ".$_."\n";
		
	    } else {
		
		unless ($folded == 1) {
		    printf XFBOOKFILE "@ \n";
		}
		$line = $_;
		
		s/>//g;
		s/<DT<A HREF=//;
		s/<\/A//;
		s/ALIAS.*=.*//;
		
		s/NICKNAME=.*//;

		s/\"mailto://;

		s/\".*//;
		
		s/ //g;
		s/,//g;
		$mailaddress = "<" . $_ . ">";

		$_ = $line;
		
		s/<DT><A HREF=\".*\"//;
		s/<\/A>//;
		s/>//;
		s/  //g;
		s/,//g;
		
		@names = split / /;
		
		if ($names[1] eq '') {
		    printf XFBOOKFILE " ".$names[0]." ".$mailaddress."\n";
		} elsif ($names[2] eq '') {
		    printf XFBOOKFILE " ".$names[0]." ".$names[1]." ".$mailaddress."\n";
		} else {
		    printf XFBOOKFILE " ".$names[0]." ".$names[1]." ".$names[2]." ".$mailaddress."\n";
		}
	    }
	} else {
	}
    }
    
    # close files
    close (NSABOOKFILE);
    close (XFBOOKFILE);
}

1;
