//
//  Newton Connection Library - Newton/UNIX Connectivity
//  Copyright (C) 1995-1997  A. E. Hall
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

char NPP_C_rcsid[] = "$Id: NPP.C,v 1.3 1997/08/24 21:38:02 spoonman Exp $";

#include <regex.h>
#include "Newton.H"

// The Newt PreProcessor!!!
String Newton::NewtPreProcessor(const String NewtFile)
  {
  return(NewtPreProcessor(NewtFile.chars()));
  };

String Newton::NewtPreProcessor(const char *NewtFile)
  {
  FILE *fptr;
  String nppFileName;

  if ((fptr=fopen(NewtFile, "r")) == NULL)
    {
    fprintf(stderr,"Newton: error reading file: %s\n",NewtFile);
    return(NewtonERROR);
    };
  nppFileName = NewtPreProcessor(fptr);
  fclose(fptr);
  return(nppFileName);
  };

String Newton::NewtPreProcessor(const FILE *fptr)
  {
  char letter;
  String nppFileName, tmpString;
  SFile nppFile;
  Regex RXcomments("//.*");           // get rid of comments
  Regex RXblank("^[ \n\t\r\v\f]+$");  // get rid of blank lines
  Regex RXleadingWhite("^ *");        // get rid of leading white space
  Regex RXtrailingWhite(" *$");       // get rid of trailing white space

  nppFileName = tmpnam(NULL);
  nppFile.open(nppFileName, 2048, ios::out, 0600);
  if (!nppFile.is_open())
    {
    fprintf(stderr, "newtl: Cannot open file: %s\n", nppFileName.chars());
    return(NewtonERROR);
    };

  while ((letter=fgetc((FILE *)fptr)) != EOF)
    {
    tmpString += letter;
    if (letter == '\n')
      {
      // the order of these regular expressions is critical
      tmpString.gsub(RXcomments, "");
      tmpString.gsub(RXblank, "");
      tmpString.gsub(RXleadingWhite, "");
      tmpString.gsub(RXtrailingWhite, "");

      nppFile.write(tmpString, tmpString.length());
      tmpString = "";
      };
    };
  nppFile.close();

  return(nppFileName);
  };

