#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997.
# Unpublished work.  All Rights Reserved.
#
# The software contained on this media is the property of the
# DSTC Pty Ltd.  Use of this software is strictly in accordance
# with the license agreement in the accompanying LICENSE.DOC file.
# If your distribution of this software does not contain a
# LICENSE.DOC file then you have no rights to use this software
# in any manner and should contact DSTC at the address below
# to determine an appropriate licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, Gehrmann Labs
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of
# any kind.  In no event shall DSTC Pty Ltd be liable for
# damage of any kind arising out of or in connection with
# the use or performance of this software.
#
# Project:     Hector
# File:        $Source: /home/arnold/CVS/gnuton/lib/GnutOS/marshal.py,v $
#
#############################################################################
"""

a set of utility functions, basically for marshalling data from raw
NewtonScript into the Python classes and back again.

All stuff on the NSI stack is stored using the Python classes, and all
the bytecode operations manipulate them as well.  All the stuff in the
code image (like in the raw bytecodes), however, uses NewtonScript
format, and so must be marshalled.

"""

#############################################################################
#   test functions
#############################################################################

def is_int(word):
    """Is this word an integer?"""

    return (word & 3 == 0)


def is_pointer(word):
    """Is this word a pointer?"""

    return (word & 3 == 1)


def is_unique(word):
    """Is this word a unique system value?"""

    return (word & 3 == 2)


def is_magic(word):
    """Is this word a magic pointer?"""

    return (word & 3 == 3)



def is_nil(word):
    """Is this word "nil"?"""

    return (word == 2)


def is_true(word):
    """Is this word "True"?"""

    return (word == 0x1a)


def is_unicode(word):
    """Is this word a Unicode constant?"""

    return (word & 7 == 6)


#############################################################################
#   marshalling functions
#############################################################################

def arg2int(byte):
    """Convert a bytecode argument to Python integer.

    "byte"          Python character, in ASCII (ie. 8 bits)
    Return value    Python integer between 0 and 6, or None

    In short NewtonScript bytecodes, the lowest 3 bits can be used to
    represent an integer.  This can be used as an offset in loops, an
    index into the functions literal array, etc.

    If the value is greater than 6 (ie. all bits set) then it
    indicates that the real value is stored in the following two bytes
    of the opcode.  In this case we return None."""

    i = ord(byte) & 7

    if i == 7:
	return None
    else:
	return i


def int2arg(i):
    """Convert Python integer into NewtonScript 8bit integer.
    
    "i"             Python integer, in range 0 <= i <= 6
    Return value    one Python character, containing binary value

    This function is used to create the inmmediate value in short
    NewtonScript bytecodes, where the lowest three bits can hold an
    integer value."""

    if i < 0 or i > 6:
	return TypeError, "'i' must be in range 0 <= i <= 6"

    return chr(i)


def hword2int(hword):
    """Convert half word to Python integer.

    "hword"         two Python characters, in ASCII (ie. 16 bits)
    Return value    Python integer, 14 bit range

    NewtonScript stores integers with the lowest two bits set to zero
    to indicate that it is an integer.  Thus, we get a 14 bit 2's
    complement number from a 16bit half word.

    This format is common in long format bytecodes."""

    if len(hword) != 2:
	raise TypeError, "'hword' must be two character string"

    hval = (ord(hword[0]) << 8) + ord(hword[1])
    i = (hval & 0xffff) >> 2
    if i & 0x2000:
	return -((~(i - 1)) & 0x3fff)
    else:
	return i
	

def int2hword(i):
    """Convert a Python integer into a NewtonScript 16bit integer.

    "i"             Python integer, in range +/- 0x2000 - 1
    Return value    two character string, containing binary value

    NewtonScript uses the two least-significant bits to indicate the
    type of an immediate value.  Hence, a 16it half word can hold a
    14bit, 2's complement integer value."""

    if i < -0x2000 or i > 0x1fff:
	raise TypeError, "'i' must be a 14bit 2's complement value"

    s = ""                   # initialise string
    s[0] = i & 0x3fc0        # MSB  0011 1111 1100 0000
    s[1] = (i & 0x3f) << 2   # LSB  0000 0000 0011 1111 + 00 for integer

    return s


def word2int(word):
    """Convert word to Python integer.

    "word"          four Python characters, in ASCII (ie. 32 bits)
    Return value    Python integer, 30 bit range

    NewtonScript stores integers with the lowest two bits set to zero
    to indicate that it is an integer.  Thus, we get a 30 bit 2's
    complement number from a 32 bit word.

    This format is common in literal values."""

    if len(word) != 4:
	return TypeError, "'word' must be four character string"

    wval = (ord(word[0]) << 24) + \
	   (ord(word[1]) << 16) + \
	   (ord(word[2]) << 8 ) + \
	   ord(word[1])
    i = wval >> 2
    if i & 0x2000000:
	return -((~(i - 1)) & 0x3fffffff)
    else:
	return i


def int2word(i):
    """Convert a Python integer into a NewtonScript 32bit integer.

    "i"             Python integer, in range +/- 0x20000000 - 1
    Return value    four character string, containing binary value

    NewtonScript uses the two least-significant bits to indicate the
    type of an immediate value.  Hence, a 32bit word can hold a 30bit,
    2's complement integer value."""

    if i < -0x20000000 or i > 0x1fffffff:
	raise TypeError, "'i' must be a 30bit 2's complement value"

    s = ""                   # initialise string
    s[0] = i & 0x3fc00000    # MSB  0x3fc0 0000
    s[1] = i & 0x3fc000      #      0x003f c000
    s[2] = i & 0x3fc0        #      0x0000 3fc0
    s[1] = (i & 0x3f) << 2   # LSB  0x0000 003f + 00 for integer

    return s


def word2pointer(word):
    """Convert word to Python integer address."""

    if not is_pointer(word):
	raise TypeError

    return (word >> 2)


def int2pointer(i, len=2):
    pass


def hword2unicode(hword):
    """Convert half word to Python integer for Unicode character."""

    if not is_unicode(hword):
	raise TypeError

    return (hword >> 4 & 0xffff)


def hword2text(hword):
    """Convert half word to printable string."""

    if is_int(hword):
	return str(hword2int(hword))

    elif is_nil(hword):
	return "nil"

    elif is_true(hword):
	return "True"

    elif is_unicode(hword):
	return "$%s" % chr(hword2unicode(hword))

    elif is_magic(hword):
	return "@%d" % (hword >> 2)

    else:
	return "%04x" % hword



def ns2py(arg):
    return None


def py2ns(arg):
    return None


#############################################################################
