#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/CVS/gnuton/lib/GnutOS/ViewConstants.py,v $
# Version:     $RCSfile: ViewConstants.py,v $ $Revision: 1.1.1.1 $
# Copyright:   (C) 1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""
ViewConstants.py

the view constants used by both the View frames and the PView classes.

"""

#############################################################################

#-- viewClass constants
kFirstClassID             = 64
clView                    = kFirstClassID + 10
clPictureView             = kFirstClassID + 12
clEditView                = kFirstClassID + 13
clKeyboardView            = kFirstClassID + 15
clMonthView               = kFirstClassID + 16
clParagraphView           = kFirstClassID + 17
clPolygonView             = kFirstClassID + 18
clRemoteView              = kFirstClassID + 24
clPickView                = kFirstClassID + 27
clGaugeView               = kFirstClassID + 28
clOutline                 = kFirstClassID + 41

#-- viewFlags constants
vNothingAllowed           = 0x00000000
vAnythingAllowed          = 0xffff << 9

vNoFlags                  = 0
vVisible                  = 1 << 0
vReadOnly                 = 1 << 1
vApplication              = 1 << 2
vCalculateBounds          = 1 << 3
vNoKeys                   = 1 << 4
vClipping                 = 1 << 5
vFloating                 = 1 << 6
vWriteProtected           = 1 << 7
vSingleUnit               = 1 << 8
vClickable                = 1 << 9
vStrokesAllowed           = 1 << 10
vGesturesAllowed          = 1 << 11
vCharsAllowed             = 1 << 12
vNumbersAllowed           = 1 << 13
vLettersAllowed           = 1 << 14
vPunctuationAllowed       = 1 << 15
vShapesAllowed            = 1 << 16
NOT_DEFINED               = 1 << 17
vPhoneField               = 1 << 18
vDateField                = 1 << 19
vTimeField                = 1 << 20
vAddressField             = 1 << 21
vNameField                = 1 << 22
vCapsRequired             = 1 << 23
vCustomDictionaries       = 1 << 24
vSelected                 = 1 << 25
vNoScripts                = 1 << 27


vClickableAllowed         = 0    #fixme
vFixedInkTextStyle        = 0    #fixme
vFixedTextStyle           = 0    #fixme

#-- viewFormat constants
vfNone                    = 0
vfWhite                   = 1
vfLtGray                  = 2
vfGray                    = 3
vfDkGray                  = 4
vfBlack                   = 5
vfCustom                  = 14
vfMatte                   = 15

vfFillWhite               = vfWhite
vfFillLtGray              = vfLtGray
vfFillGray                = vfGray
vfFillDkGray              = vfDkGray
vfFillBlack               = vfBlack
vfFillCustom              = vfCustom
vfFillMask                = 15
vfFillShift               = 0

vfFrameWhite              = vfWhite * 16
vfFrameLtGray             = vfLtGray * 16
vfFrameGray               = vfGray * 16
vfFrameDkGray             = vfDkGray * 16
vfFrameBlack              = vfBlack * 16
vfFrameMatte              = vfMatte * 16
vfFrameMask               = vfFillMask * 16
vfFrameShift              = 4

vfFrameDragger            = 208
vfFrameCustom             = 224

vfLinesWhite              = vfWhite * 4096
vfLinesLtGray             = vfLtGray * 4096
vfLinesGray               = vfGray * 4096
vfLinesDkGray             = vfDkGray * 4096
vfLinesBlack              = vfBlack * 4096
vfLinesCustom             = vfCustom * 4096
vfLinesMask               = vfFillMask * 4096
vfLinesShift              = 12

vfInsetMask               = 3 * 65536
vfInsetShift              = 16

vfShadowMask              = 3 * 262144
vfShadowShift             = 18

vfHiliteInvert            = 0 * 1048576
vfHiliteBullet            = 2 * 1048576
vfHiliteTriangle          = 4 * 1048576
vfHiliteMask              = 15 * 1048576
vfHiliteShift             = 20

vfRoundMask               = 15 * 16777216
vfRoundShift              = 24

#-- viewJustify constants
vjLeftH                   = 0 * 1
vjRightH                  = 1 * 1
vjCenterH                 = 2 * 1
vjFullH                   = 3 * 1
vjHMask                   = 3 * 1
vjTopV                    = 0 * 4
vjCenterV                 = 1 * 4
vjBottomV                 = 2 * 4
vjFullV                   = 3 * 4
vjVMask                   = 3 * 4

vjParentLeftH             = 0 * 16
vjParentCenterH           = 1 * 16
vjParentRightH            = 2 * 16
vjParentFullH             = 3 * 16
vjParentHMask             = 3 * 16
vjParentTopV              = 0 * 64
vjParentCenterV           = 1 * 64
vjParentBottomV           = 2 * 64
vjParentFullV             = 3 * 64
vjParentVMask             = 3 * 64

vjSiblingNoH              = 0 * 512
vjSiblingCenterH          = 1 * 512
vjSiblingRightH           = 2 * 512
vjSiblingFullH            = 3 * 512
vjSiblingLeftH            = 4 * 512
vjSiblingHMask            = 7 * 512
vjSiblingNoV              = 0 * 4096
vjSiblingCenterV          = 1 * 4096
vjSiblingBottomV          = 2 * 4096
vjSiblingFullV            = 3 * 4096
vjSiblingTopV             = 4 * 4096
vjSiblingVMask            = 7 * 4096
vjSiblingMask             = vjSiblingHMask + vjSiblingVMask
vjChildrenLasso           = 1 * 32768
vjReflow                  = 1 * 65536

noLineLimits              = 0 * 8388608
oneLineOnly               = 1 * 8388608
oneWordOnly               = 2 * 8388608

vjNoRatio                 = 0
vjLeftRatio               = 67108864
vjRightRatio              = 134217728
vjTopRatio                = 268435456
vjBottomRatio             = -536870912
vjParentAnchored          = 256


#############################################################################

left = "left"
right = "right"
top = "top"
bottom = "bottom"


#############################################################################
